	subroutine BC(iout, idbg, Nn, Nb, Ng, BCe, BCvalue, BCtype, &
			T, Son, wg, a33, Shpb)
! update BC
! *** IMPORTANT: T is positive for outflow and negative for inflow ***

	implicit none
	integer iout, idbg
	integer Nn, Nb, Ng			! array parameters
	integer BCe(Nb,3)			! BC element numbers
	real*8 BCvalue(Nb,2)			! BC value (jx_bar, qx_bar or c_bar)
	character*1 BCtype(Nb)			! BC type ('N' or 'D')
	real*8 T   (Nn)				! global  array
	real*8 Son (Nn)				! global  array
	real*8 wg(Ng)				! Gauss weights
	real*8 a33(Nb)				! boundary geometric entities
	real*8 Shpb(2,Nb,Ng)			! boundary shape functions

	integer i, j, n, g1b			! local indices
	integer ii				! global index
	real*8 BCv(2), w, Te(2)

!	write(idbg,'(a)') ' --- BC ---'	! ### TEMPORARY ###

! reset T to Son in case that a node has more than one BC
	T = Son		! use matrix form

	  do n = 1, Nb
	    BCv(:) = BCvalue(n,:)	! BC value
! reset Te to 0
	    Te = 0.

	    if (BCtype(n) .eq. 'N') then
! Neumann BC
!-----------
	      do g1b = 1, Ng
	        w = wg(g1b)
	        do i = 1,2
	          do j = 1,2
	            Te(i) = Te(i) + w * SHPb(i,n,g1b) * BCv(j) * SHPb(j,n,g1b) * a33(n)
	          enddo		! j
	        enddo		! i
	      enddo		! g1b

! calculate and store in T
	      do i = 1,2
	        ii= BCe(n,i)				! BC global node i number
	        T(ii) = T(ii) + Te(i)
	      enddo	! i

	    endif
	  enddo	! n

	return
	end

